%    This library is free software; you can redistribute it and/or
%    modify it under the terms of the GNU Lesser General Public
%    License as published by the Free Software Foundation; either
%    version 2.1 of the License, or (at your option) any later version.

%    This library is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%    Lesser General Public License for more details.

%    You should have received a copy of the GNU Lesser General Public License 
%    (lgpl_license.txt) along with this library; if not, write to the Free Software
%    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

function initial_contour(iteration)

filename = ['init_to_inter_lsm_', num2str(iteration), '_unique'];
fid = fopen(filename, 'r');

A = fscanf(fid, '%f %f', [2 inf]); 
A = A';
fclose(fid); 

%%%%%%%%%% COULD CONSIDER ADDING PERTURBATION OF A VALUES HERE. %%%%%%%%%%%%

%size(A)

figure
len = size(A,1);

% Red
A(1:0.1*len,1) = A(1:0.1*len,1) + 5;
A(1:0.1*len,2) = A(1:0.1*len,2) - 10;

% Yellow
A(0.1*len+1:0.2*len,1) = A(0.1*len+1:0.2*len,1) + 3;
A(0.1*len+1:0.2*len,2) = A(0.1*len+1:0.2*len,2) + 0;

% Cyan
A(0.2*len+1:0.25*len,1) = A(0.2*len+1:0.25*len,1) + 7;
A(0.2*len+1:0.25*len,2) = A(0.2*len+1:0.25*len,2) -6;

A(0.25*len+1:0.3*len,1) = A(0.25*len+1:0.3*len,1) - 5;
A(0.25*len+1:0.3*len,2) = A(0.25*len+1:0.3*len,2) - 8;


plot(A(1:0.1*len,1),A(1:0.1*len,2),'ro');
hold on;
plot(A(0.1*len+1:0.2*len,1),A(0.1*len+1:0.2*len,2),'yo');
plot(A(0.2*len+1:0.3*len,1),A(0.2*len+1:0.3*len,2),'co');
plot(A(0.3*len+1:0.4*len,1),A(0.3*len+1:0.4*len,2),'go');
plot(A(0.4*len+1:0.5*len,1),A(0.4*len+1:0.5*len,2),'bo');
plot(A(0.5*len+1:0.6*len,1),A(0.5*len+1:0.6*len,2),'mo');
plot(A(0.6*len+1:0.7*len,1),A(0.6*len+1:0.7*len,2),'ko');
plot(A(0.7*len+1:0.8*len,1),A(0.7*len+1:0.8*len,2),'rx');
plot(A(0.8*len+1:0.9*len,1),A(0.8*len+1:0.9*len,2),'yx');
plot(A(0.9*len+1:len,1),A(0.9*len+1:len,2),'gx');	

%A(:,1) = A(:,1)+A(:,1)*rand*0.2;

pause

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

h = figure; 
plot(A(:,1), A(:,2), 'Color', 'r');
 hold on; 
 plot(A(500,1), A(500,2), 'x', 'LineWidth', 2, 'MarkerSize', 10, 'MarkerEdgeColor', rgb('Red')); 
 hold on; 
 plot(A(80,1), A(80,2), 'x', 'LineWidth', 2, 'MarkerSize', 10, 'MarkerEdgeColor', rgb('Red')); 

%%%%%%%%%% C = Coarsened version of inner boundary (A) ---> Leave fixed. %%%%%%%%%%

 %%%% user should control this part 
C = A(1:3:80,:); 
tmp = A(85:5:500,:);
C = cat(1,C,tmp);
tmp = A(503:3:end,:);
C  = cat(1, C,tmp);
hold on;
plot(C(:,1), C(:,2), 'x');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%% B = Outer Boundary --> Leave fixed. %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
fid = fopen('outer_init_xy_lsm', 'r'); 

B = fscanf(fid, '%d %d', [2 inf]); 
B = B';
fclose(fid); 

hold on;
plot(B(:,1), B(:,2), 'x'); 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

filename = ['init_to_inter_lsm_', num2str(iteration), '_boundary.poly'];
fid = fopen(filename, 'w');
fprintf(fid, '%d\t%d\t%d\t%d\n', size(C,1) + size(B,1), 2, 0, 0); %%%% vertices information

index = 1;
while index <= size(C,1)
    fprintf(fid, '%d\t%f\t%f\t%d\n', index, C(index,1), C(index,2), 1);
    index = index + 1;
end

index = 1;
while index <= size(B,1)
    fprintf(fid, '%d\t%f\t%f\t%d\n', index+size(C,1), B(index,1), B(index,2), 2);
    index = index + 1;
end

fprintf(fid, '%d\t%d\n', size(C,1) + size(B,1), 0); %%%% elements information
first = size(C,1);
i = 1;
while i <= first-1
    fprintf(fid, '%d\t%d\t%d\t%d\n', i, i, i+1, 1); 
    i = i + 1;
end
fprintf(fid, '%d\t%d\t%d\t%d\n', i, i, 1, 1);

i = 1;
while i <= size(B,1)-1
    fprintf(fid, '%d\t%d\t%d\t%d\n', i+first, i+first, i+first+1, 2);
    i = i + 1;
end
fprintf(fid, '%d\t%d\t%d\t%d\n', i+first, i+first, first+1, 2);

fprintf(fid, '%d\n', 1); %%%% hole information
fprintf(fid, '%d\t%d\t%d\n', 1,290,300);
fclose(fid);



figure
plot(C(:,1),C(:,2),'bx');
hold on;
plot(B(:,1),B(:,2),'y*');




